 ; Ŀ
 ;   Cope - update files from the network if required.                     
 ;   Copyright 2002 by Rocket Software Ltd.                                
 ;                                                                         
 ;   Put files on L:.  Run Srd to update the remote date file.             
 ;   All machines run Cope on drawing (or Acad?) startup.  If the          
 ;   local date file is earlier than the remote one then the files are     
 ;   copied to the local drive and update the local date file.             
 ;   Since Cope can copy itself from L: and runs itself, it can be         
 ;   rewritten to make other changes.                                      
 ;   Acad2.lsp is copied down from Acad2.lisp on L: so that it can be      
 ;   placed in Rocket rather than under Lisp.                              
 ; 

 ; Ŀ
 ;   Srd - set the date and time in the remote file.                       
 ;   Not a subroutine.                                                     
 ; 
 (DEFUN C:SRD (/ fn)
  (setq fn (open "l:\\engineering\\drafting\\elecsave\\datx.jul" "w"))
  (write-line (rtos (getvar "date") 2 8) fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Srd end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Cope - copy files off L:.                                  
 ;   Could be rewritten to find each file on L:, find the matching file    
 ;   on c:, and overwrite it with the one from L:.                         
 ; 
 (DEFUN COPE (/ pref ac2 ac2lsp)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Find the dir containing Fang.lsp, copy all .lsp files there from L:.  
 ; 
  (setq pref (findfile "fang.lsp"))
  (setq pref (substr pref 1 (- (strlen pref) 8)))
  (setq pref (strcat "\"" pref "\""))
  (command "shell" (strcat "copy "
                           "\"L:\\ENGINEERING\\DRAFTING\\ElecSave\\*.lsp\" "
                           pref))
 ; Ŀ
 ;   Find the dir containing Coil.dwg, copy all .dwg files there from L:.  
 ; 
  (setq pref (findfile "coil.dwg"))
  (setq pref (substr pref 1 (- (strlen pref) 8)))
  (setq pref (strcat "\"" pref "\""))
  (command "shell" (strcat "copy "
                           "\"L:\\ENGINEERING\\DRAFTING\\ElecSave\\*.dwg\" "
                           pref))
 ; Ŀ
 ;   Find Acad2.lsp, overwrite it with Acad2.lisp (sic) from L:.           
 ; 
  (if (and (setq ac2 (findfile "L:\\ENGINEERING\\DRAFTING\\ElecSave\\acad2.lisp"))
           (setq ac2lsp (findfile "acad2.lsp")))
      (command "shell" (strcat "copy \"" ac2 "\" \"" ac2lsp "\"")))
 (princ))
 ; Ŀ
 ;   Subroutine Cope end.                                                  
 ; 

 ; Ŀ
 ;   Sld - set the date and time in the local file.                        
 ; 
 (DEFUN SLD (/ pref fn)
  (setq pref (findfile "acad2.lsp"))
  (setq pref (substr pref 1 (- (strlen pref) 9)))
  (setq fn (open (strcat pref "datx.jul") "w"))
  (write-line (rtos (getvar "date") 2 8) fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Sld end.                                                              
 ; 

 ; Ŀ
 ;   Timers St1 and Ct2.                                                   
 ; 
 (DEFUN ST1 (/ s)
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))
 (princ))
       
 (DEFUN CT2 (/ s t2)
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (write-line (strcat "Elapsed time: " (rtos (- t2 t1) 2 2) " seconds."))
 (princ))
 ; Ŀ
 ;   Timers end.                                                           
 ; 

 ; Ŀ
 ;   Cope - If there is a remote date and it is later than the local       
 ;   one or there is no local date file then copy program files from       
 ;   the remote location and update the local file to the current time.    
 ; 
 (DEFUN C:COPE (/ pref fn locdat remdat)
; (st1)
  (setq pref (findfile "acad2.lsp"))
  (setq pref (substr pref 1 (- (strlen pref) 9)))
  (if (setq fn (open (strcat pref "datx.jul") "r"))
      (progn
           (setq locdat (read-line fn))
           (close fn)))
  (if (setq fn (open "l:\\engineering\\drafting\\elecsave\\datx.jul" "r"))
      (progn
           (setq remdat (read-line fn))
           (close fn)))
; (print locdat)
; (print remdat)
  (if (and remdat (or (null locdat) (> (read remdat) (read locdat))))
      (progn
           (cope)
           (sld)))
; (ct2)
 (princ))

(princ)